 
clear all
close all

%% load model run

% dimension 1 - subglacial erosion
% dimension 2 - subaerial erosion
% dimension 3 - d18O threshold
% dimension 4 - sample number

R1 = load("outputs/Mar24Run_2.7Myr_3.60-3.68_variablegrid.mat");
R2 = load("outputs/Mar24Run_2.7Myr_3.70-3.78_variablegrid.mat");
R3 = load("outputs/Mar24Run_2.7Myr_3.80-3.88_variablegrid.mat");
R4 = load("outputs/Mar24Run_2.7Myr_3.90-4.0_variablegrid.mat");

%% merge outputs

d = R1.d;
model.esa = R1.model.esa;
model.egl = R1.model.egl;

model.x2 = cat(3, R1.model.x2, R2.model.x2, R3.model.x2, R4.model.x2);
model.oxy = cat(2, R1.model.oxy, R2.model.oxy, R3.model.oxy, R4.model.oxy);

% load("outputs/Feb10Run_all.mat");

%% Organize by distance to coast

% get relevant outputs in correct order - note that only doing for outputs
% used below, so if want to explore nuclide concentrations, for example,
% would need to add here.

for i = 1:length(d)
    deglac(i) = d{i}.deglac_t;
end

[test, order] = sort(deglac, 'descend');

for i = 1:length(d)
    xtlbl{i} = d{order(i)}.id;
    d_ordered{i} = d{order(i)};
    model.x2_ordered(:, :, :, i) = model.x2(:, :, :, order(i));
end





%% get best values
find_best_hist = squeeze(squeeze(min(model.x2_ordered, [], [1 2])));

% % best fitting sum
% x2_tot_hist = sum(find_best_hist, 2);
% x2red_tot_hist = sum(find_best_hist, 2)./(length(d)-1);
% [best_x2red best_hist_indx] = min(x2red_tot_hist);

% most non-outlier samples with misfit < 2.5
[temp_val best_hist_indx] = max(sum(find_best_hist(:, [3:4 6:15])<=2.5, 2));
best_hist = model.oxy(best_hist_indx);

[M I] = min(squeeze(model.x2(:, :, best_hist_indx, :)), [], [1 2], "linear");
[best_egl_idx, best_esa_idx, ~] = ind2sub(size(squeeze(model.x2_ordered(:, :, best_hist_indx, :))),squeeze(I));

best_egl = model.egl(best_egl_idx);
best_esa = model.egl(best_esa_idx);
best_fmin = squeeze(squeeze(M));

%% make plot

plotx2_egl = zeros(length(model.egl), length(d)+1);
plotx2_esa = zeros(length(model.esa), length(d)+1);

for a = order
    plotx2_egl(:, a) = squeeze(model.x2_ordered(:, best_esa_idx(a), best_hist_indx, a));
    plotx2_esa(:, a) = squeeze(model.x2_ordered(best_egl_idx(a), :, best_hist_indx, a));
end

%% display X2 at all of each erosion rate

% make one plot for each erosion type. take the lowest X2 along each erosion
% rate. so for example, the subglacial erosion rate plot shows the lowest X2
% value for each tested subglacial erosion rate across all runs with the favored
% exposure history.

% figure(3)

d_indx = [1:length(d_ordered)]; % remember to pick indices from ordered structure 

all_egl_x2 = zeros(length(model.egl), length(d_indx)+1);
all_esa_x2 = zeros(length(model.esa), length(d_indx)+1);
 
for a = 1:length(d_indx)
    [all_egl_x2(:, a) ~] = min(model.x2_ordered(:, :, best_hist_indx, d_indx(a)),[], 2);
    [all_esa_x2(:, a) ~] = min(model.x2_ordered(:, :, best_hist_indx, d_indx(a)), [], 1);
    xtlbl{a} = d_ordered{d_indx(a)}.id;
end



%% Subglacial erosion plot

cmap = parula(255);

figure(3)

[Xegl Yegl] = meshgrid(1:(length(d_indx)+1), model.egl);
alphamask_egl = all_egl_x2<=2.5;

hAxegl(1)=axes('Color', 'none');
xlim([1 length(d_indx)+1])
ylim([1e-9 2.5e-2])
set(hAxegl(1), 'Yscale', 'log')
hAxegl(2) = axes('Color', 'none');
c = colorbar(hAxegl(2));
set(hAxegl(2), 'Yscale', 'log')
xlim([1 length(d_indx)+1])
ylim([1e-9 2.5e-2])
linkaxes(hAxegl)
linkprop(hAxegl, 'Position');

egl_inv = pcolor(hAxegl(1), Xegl, Yegl, all_egl_x2);
    colormap(hAxegl(1),cmap);
    c = colorbar(hAxegl(1));
    c.Label.String = 'Error-weighted sum of squares';
    c.Label.FontSize = 14;
    c.Label.Rotation = -90;
    c.Label.Position = [2.5950+0.1 1.2500 0];
    caxis(hAxegl(1), [0 2.5]);
shading flat
alphamask_inv = all_egl_x2<0;
set(egl_inv,'alphadata',alphamask_inv,'facealpha','flat','edgecolor','none');
set(hAxegl(1), 'YScale', 'log', 'XTick', [1:length(d_indx)]+0.5, 'XTickLabel', xtlbl, 'YTickLabel', {}, 'FontSize', 14, 'XTickLabelRotation', 45)
% set(hAxegl(1), 'YScale', 'log', 'XTick', [1:length(d_indx)]+0.5, 'XTickLabel', {}, 'YTickLabel', {}, 'FontSize', 14)
xlim([1 length(d_indx)+1])
% ylim([1e-5 model.egl(end)])
ylim([1e-5 3e-2])
xtickangle(45)
box on


egl_plot = pcolor(Xegl, Yegl, all_egl_x2);
    colormap(hAxegl(2),cmap);
    caxis(hAxegl(2), [0 2.5]);
shading flat
set(egl_plot,'alphadata',alphamask_egl,'facealpha','flat','edgecolor','none');
grid on
ylabel(hAxegl(2), 'Subglacial erosion rate (mm yr^{-1})', 'FontSize', 16)
set(hAxegl(2), 'YScale', 'log', 'XTick', [1:length(d_indx)], 'XTickLabel', {}, 'FontSize', 14, 'XTickLabelRotation', 45)
set(hAxegl(2), 'XGrid', 'on', 'YGrid', 'on', 'Layer', 'bottom');
xlim([1 length(d_indx)+1])
% ylim([1e-5 model.egl(end)])
ylim([1e-5 3e-2])
xtickangle(45)
box on


%% Subaerial erosion plot 

figure(4)

[Xesa Yesa] = meshgrid(1:(length(d_indx)+1), model.esa);
alphamask_esa = all_esa_x2<=2.5;


hAx(1)=axes('Color', 'none');
xlim([1 length(d_indx)+1])
ylim([1e-9 2.5e-2])
set(hAx(1), 'Yscale', 'log')
hAx(2) = axes('Color', 'none');
c = colorbar(hAx(2));
set(hAx(2), 'Yscale', 'log')
xlim([1 length(d_indx)+1])
ylim([1e-9 2.5e-2])
linkaxes(hAx)
linkprop(hAx, 'Position');


esa_inv = pcolor(hAx(1), Xesa, Yesa, all_esa_x2);
    colormap(hAx(1),cmap);
    c = colorbar(hAx(1));
    c.Label.String = 'Error-weighted sum of squares';
    c.Label.FontSize = 14;
    c.Label.Position = [2.5950+0.1 1.2500 0];
    caxis(hAx(1), [0 2.5]);
    c.Label.Rotation = -90;
shading flat
alphamask_inv = all_esa_x2<0;
set(esa_inv,'alphadata',alphamask_inv,'facealpha','flat','edgecolor','none');
set(hAx(1), 'YScale', 'log', 'XTick', [1:length(d_indx)]+0.5, 'XTickLabel', xtlbl, 'YTickLabel', {}, 'FontSize', 14, 'XTickLabelRotation', 45)
xlim([1 length(d_indx)+1])
% ylim([1e-5 model.esa(end)])
ylim([1e-5 3e-2])
xtickangle(45)
box on

esa_plot = pcolor(hAx(2), Xesa, Yesa, all_esa_x2);
    colormap(hAx(2),cmap);
    caxis(hAx(2), [0 2.5]);
shading flat
set(esa_plot,'alphadata',alphamask_esa,'facealpha','flat','edgecolor','none');
grid on
ylabel(hAx(2), 'Subaerial erosion rate (mm yr^{-1})', 'FontSize', 16)
set(hAx(2), 'YScale', 'log', 'XTick', [1:length(d_indx)], 'XTickLabel', {}, 'FontSize', 14, 'XTickLabelRotation', 45)
set(hAx(2), 'XGrid', 'on', 'YGrid', 'on', 'Layer', 'bottom');
xlim([1 length(d_indx)+1])
% ylim([1e-5 model.esa(end)])
ylim([1e-5 3e-2])
xtickangle(45)
box on

%% color map for each sample 

% to look at relationship between subaerial and subglacial erosion rates
% for each sample. Figure not included in paper. Axes not dynamic for each
% subplot - will need to zoom in a lot to see results.

% make colormap with white for values above caxis upper limit
high = [1 1 1];
cmap_indv = [parula(255); high];


% could later make to be by group
figure(5)
for a = 1:length(d_indx)
subplot(4, 4, a)

    this_map = model.x2(:, :, best_hist_indx, d_indx(a));
  
    pcolor(model.esa, model.egl, this_map)
    colormap(cmap_indv);
   
    % c = colorbar;
    caxis([0 2.5]);
    shading flat
    ylabel('glacial')
    xlabel('aerial')
    title(d{d_indx(a)}.id)
    grid on
end

%% d18O for each sample

% find best X2 for each d18O threshold for each sample

for a = 1:length(d)
    plotx2_oxy(:, a) = min(squeeze(model.x2_ordered(:, :, :, a)),[], [1 2]);
end

all_oxy_x2 = zeros(length(model.oxy), length(d_indx)+1);

for a = 1:length(d_indx)
    all_oxy_x2(:, a) = plotx2_oxy(:, d_indx(a));
end

all_oxy_x2(end+1, :) = NaN;
pcolor_oxy = [model.oxy model.oxy(end)+0.02];

[Xoxy Yoxy] = meshgrid(1:(length(d_indx)+1), pcolor_oxy);
alphamask_oxy = all_oxy_x2<=2.5;

figure(6)
% figure(1)
% subplot(3, 1, 1)

hAxoxy(1)=axes('Color', 'none');
xlim([1 length(d_indx)+1])
ylim([model.oxy(1) model.oxy(end)+0.02])
set(hAxoxy(1), 'Yscale', 'linear')
hAxoxy(2) = axes('Color', 'none');
c = colorbar(hAxoxy(2));
set(hAxoxy(2), 'Yscale', 'linear')
xlim([1 length(d_indx)+1])
ylim([model.oxy(1) model.oxy(end)+0.02])
linkaxes(hAxoxy)
linkprop(hAxoxy, 'Position', 'Rulers');

oxy_inv = pcolor(hAxoxy(1), Xoxy, Yoxy,  all_oxy_x2);
    colormap(hAxoxy(1),cmap);
    c = colorbar(hAxoxy(1));
    c.Label.String = 'Error-weighted sum of squares';
    c.Label.FontSize = 14;
    c.Label.Position = [2.5950+0.1 1.2500 0];
    caxis(hAxoxy(1), [0 2.5]);
    c.Label.Rotation = -90;
shading flat
alphamask_inv =  all_oxy_x2<0;
set(oxy_inv,'alphadata',alphamask_inv,'facealpha','flat','edgecolor','none');
set(hAxoxy(1), 'YScale', 'linear', 'XTick', [1:length(d_indx)]+0.5, 'XTickLabel', xtlbl, 'YTickLabel', {}, 'FontSize', 14, 'XTickLabelRotation', 45)
% set(hAxoxy(1), 'YScale', 'linear', 'XTick', [1:length(d_indx)]+0.5, 'XTickLabel', {}, 'YTickLabel', {}, 'FontSize', 14)
xlim([1 length(d_indx)+1])
ylim([model.oxy(1) model.oxy(end)+0.02])
XTickLabel.FontSize = 6;
xtickangle(45)
box on

oxy_plot = pcolor(hAxoxy(2), Xoxy, Yoxy,  all_oxy_x2);
    colormap(hAxoxy(2),cmap);
    caxis(hAxoxy(2), [0 2.5]);
shading flat
set(oxy_plot,'alphadata',alphamask_oxy,'facealpha','flat','edgecolor','none');
grid on
ylabel(hAxoxy(2), '\delta^{18}O Threshold (‰)', 'FontSize', 16)
set(hAxoxy(2), 'YScale', 'linear', 'XTick', [1:length(d_indx)], 'XTickLabel', {}, 'YTick', [3.6:0.02:4.2], 'FontSize', 14, 'XTickLabelRotation', 45)

set(hAxoxy(2), 'XGrid', 'on', 'YGrid', 'on', 'Layer', 'bottom');
xlim([1 length(d_indx)+1])
ylim([model.oxy(1) model.oxy(end)+0.02])
box on

%% Calculate total erosion 

% need to run oxy to get history. then get total exposure and burial
% durations. for total erosion multiply each type of erosion by respective
% time and sum for all values. for last glacial cycle, do same but only to ~100 ka or
% whatever. so will calculate once but then map to values from erosion
% plots above. oh actually just need to do for 3.74. but shoould get
% history values for all. can do this on the bus. 

% calculate all histories

oxy_val = [3.6:0.02:4.0]; 
fix = 30;

for a = 1:length(oxy_val)
    history_temp = hist_param(oxy_val(a), fix);
    exp_bur(a, 1) = sum(history_temp.t_eb .* history_temp.p_mask);
    exp_bur(a, 2) = sum(history_temp.t_eb .* (history_temp.p_mask == 0))+ 20e3; % extend to 10 ka
    lgm_dur(a, :) = history_temp.t_eb(end) + 20e3; % to 10 ka
end

total_e = ((exp_bur(:, 1).*model.egl) + (exp_bur(:, 2).*model.esa))./1e3;
lgm_e = ((lgm_dur(:, 1).*model.egl))./1e3;

%% plot best history on d18O curve

fix_time = 30 .* 1e3; % time after which exposure history is defined downstream
                      % to avoid any extra threshold crossings. 
smoothing_time = 30;

best_hist_plot = get_oxygen_mask(fix_time, best_hist, smoothing_time, 1); 
filly = [0 5 5 0 0];

figure(9)
panelx = 0.15;
panelw = 0.75;

ht1 = 0.7;
bot1 = 0.13;

ht2 = 0.04;
bot2 = bot1 + ht1 + 0.02;

ax1 = axes('pos',[panelx bot1 panelw ht1]);
ax2 = axes('pos',[panelx bot2 panelw ht2]);

axes(ax2)
hold on

for a = 1:length(best_hist_plot.model_times)
    if best_hist_plot.model_mask(a) == 1
        c = [148, 17 0]./256;
    elseif best_hist_plot.model_mask(a) == 0
        c = [118 214 255]./256;
    end
        fill([best_hist_plot.switch_times(a) best_hist_plot.switch_times(a) (best_hist_plot.switch_times(a)-best_hist_plot.model_times(a)) (best_hist_plot.switch_times(a)-best_hist_plot.model_times(a)) best_hist_plot.switch_times(a)]./1e6, filly, c, 'EdgeColor','none')
end

% add ice cover from 30-10 ka, as the exposure history after 30 ka is
% currently user defined. exposure history after 10 ka is specific to each
% sampling location so is not shown on this figure.

hold on
fill([0.03 0.03 0.01 0.01 0.03], filly, [118 214 255]./256, 'EdgeColor','none')

set(gca, 'xlim', [0 2.7e6]./1e6, 'ylim', [-0.1 5.1])
box on
yticks([])
xticks([])

axes(ax1)
hold on
plot([best_hist_plot.time./1e6; 0.01], [best_hist_plot.oxygen_isotopes; 3.52], 'k-')
plot([0; best_hist_plot.time./1e6], best_hist_plot.glaciation_threshold.*ones(length(best_hist_plot.time)+1, 1), '-', 'Color', [0 145 110]./256, 'linewidth', 1.5)
set(gca, 'xlim', [0 2.7e6]./1e6, 'ylim', [3.2 5])
set(gca, 'ydir', 'reverse', 'FontSize', 14)
xlabel('Time (Ma)', 'FontSize', 16)
ylabel('\delta^{18}O Threshold (‰)', 'FontSize', 16)
grid on 
box on